/*
* Copyright (c) 1994-1998 Sun Microsystems, Inc. All Rights Reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for NON-COMMERCIAL or COMMERCIAL purposes and without fee is
* hereby granted. Please refer to the file
* http://java.sun.com/nav/business/trademark_guidelines.html for further
* important copyright and trademark information and to
* http://java.sun.com/nav/business/index.html for further important licensing
* information for the Java (tm) Technology.
* 
* SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
* SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
* IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
* NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
* LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
* ITS DERIVATIVES.
* 
* THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
* CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE PERFORMANCE,
* SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT NAVIGATION OR
* COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE SUPPORT MACHINES, OR
* WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE SOFTWARE COULD LEAD DIRECTLY TO
* DEATH, PERSONAL INJURY, OR SEVERE PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH
* RISK ACTIVITIES"). SUN SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED
* WARRANTY OF FITNESS FOR HIGH RISK ACTIVITIES.
*/

import java.awt.*;
import java.applet.*;
import java.net.*;

public class JavaLogo extends Applet implements Runnable
{
   private Thread animate;
   private Dimension size;
   private URL docBase;

   private Graphics offG;
   private Image offImage;
   private MediaTracker tracker;
   private String imageName;
   private Image image;
   private Sprite sprite;

   private String link;
   private String target;
   private Color bgcolor;
   private int delay;
   private int number;
   private int loop;

   public void init()
   {
      size = size();

      // Parse the background color.

      String value = getParameter("bgcolor");

      if (value != null)
      {
         bgcolor = new Color(Integer.parseInt(value, 16));
      }

      else
      {
         bgcolor = Color.white;
      }

      setBackground(bgcolor);

      // Parse the number of frames.

      value = getParameter("number");

      if (value != null)
      {
         number = Integer.parseInt(value);
      }

      else
      {
         number = 0;
      }

      offImage = createImage((number + 1) * size.width, size.height);
      offG = offImage.getGraphics();

      // Parse the frame delay.

      value = getParameter("delay");

      if (value != null)
      {
         delay = Integer.parseInt(value);
      }

      else
      {
         delay = 100;
      }

      // Parse the loop value;

      value = getParameter("loop");

      if (value != null)
      {
         loop = Integer.parseInt(value);
      }

      else
      {
         loop = 0;
      }

      // Parse the link value;

      value = getParameter("link");

      if (value != null)
      {
         link = new String(value);
      }

      else
      {
         link = null;
      }

      // Parse the target value;

      value = getParameter("target");

      if (value != null)
      {
         target = new String(value);
      }

      else
      {
         target = "_self";
      }

      // Parse the image name value;

      value = getParameter("image");

      if (value != null)
      {
         imageName = new String(value);
      }

      else
      {
         imageName = null;
      }

      docBase = getDocumentBase();

      if (imageName != null)
      {
         image = getImage(docBase, imageName);
         tracker = new MediaTracker(this);
         tracker.addImage(image, 0);

         try
         {
            tracker.waitForAll();
            offG.drawImage(image, size.width, 0, this);
            sprite = new Sprite(number, size, loop);
         }

         catch (InterruptedException e)
         {
            e.printStackTrace();
         }
      }
   }

   public void start()
   {
      if ((animate == null) || (!animate.isAlive()))
      {
         animate = new Thread(this);
      }

      animate.start();
   }

   public void run()
   {
      while (Thread.currentThread() == animate)
      {
         try
         {
            repaint();
            Thread.sleep(delay);
         }

         catch (InterruptedException e)
         {
            e.printStackTrace();
         }
      }
   }

   public void stop()
   {
      if ((animate != null) && (animate.isAlive()))
      {
         animate.stop();
      }
   }

   public void destroy()
   {
      animate = null;
   }

   public void update(Graphics g)
   {
      if (sprite != null)
      {
         sprite.draw(offG);
      }

      paint(g);
   }

   public void paint(Graphics g)
   {
      g.drawImage(offImage, 0, 0, this);
   }

   public boolean mouseDown(Event evt, int x, int y) 
   {
      if (link != null)
      {
         try
         {
            URL url = new URL(docBase, link);
            getAppletContext().showDocument(url, target);

            if (target.equals("_self"))
            {
               stop();
            }
         }

         catch (MalformedURLException e)
         {
            e.printStackTrace();
         }
      }

      return(true);
   }

   public boolean mouseEnter(Event evt, int x, int y) 
   {
      if (link != null)
      {
         showStatus(link);
      }

      return(true);
   }

   public boolean mouseExit(Event evt, int x, int y) 
   {
      if (link != null)
      {
         showStatus("");
      }

      return(true);
   }
}
